<?php
// FILE: whatsapp_handler.php (UPDATED)

// Include the Twilio PHP SDK
require_once __DIR__ . '/vendor/autoload.php';
use Twilio\TwiML\MessagingResponse;

// Include your core logic. This file now handles the database connection and
// all configuration loading internally.
require_once 'bot_core_logic.php';

// Get the incoming message from Twilio
$userMessage = $_POST['Body'] ?? '';
$fromNumber = $_POST['From'] ?? ''; // e.g., whatsapp:+254...

// Log the incoming message for debugging
error_log("WhatsApp message from $fromNumber: $userMessage");

// --- Process the message using the core bot logic ---
// We use the new, simplified function call.
// We also specify 'whatsapp' as the output channel for correct formatting.
$botReply = getBotResponse($userMessage, [], 'en-US', 'whatsapp');

// --- Send the reply back to WhatsApp using TwiML ---
$response = new MessagingResponse();
$response->message($botReply);

header('Content-Type: text/xml');
echo $response;
?>