<?php
// FILE: public_html/includes/footer.php

// --- DATA CONFIGURATION ---
$footer_links = [
    ['href' => 'index.php', 'label' => 'Home'],
    ['href' => 'projects.php', 'label' => 'All Projects'],
    ['href' => 'news.php', 'label' => 'Latest News'],
    ['href' => 'join.php', 'label' => 'Join the Movement'],
    ['href' => 'contact.php', 'label' => 'Contact Us'],
    ['href' => 'privacy_policy.php', 'label' => 'Privacy Policy'],
    ['href' => 'https://homabay.go.ke/', 'label' => 'Homa Bay County Website', 'external' => true],
];

// Ideally, this SVG path data would be in a separate helper file, but putting it in an array is cleaner than inline HTML.
$social_links = [
    [
        'href' => 'https://www.facebook.com/GladysWanga043/',
        'label' => 'Follow on Facebook',
        'icon' => 'M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z'
    ],
    [
        'href' => 'https://twitter.com/gladyswanga',
        'label' => 'Follow on Twitter',
        'icon' => 'M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.71v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84'
    ],
    [
        'href' => 'http://googleusercontent.com/youtube.com/8', // Note: This URL looks suspicious/broken in your original file. Verify it.
        'label' => 'Subscribe on YouTube',
        'icon' => 'M19.812 5.418c.861.23 1.538.907 1.768 1.768C21.998 8.78 22 12 22 12s0 3.22-.418 4.814a2.506 2.506 0 0 1-1.768 1.768c-1.594.418-7.814.418-7.814.418s-6.22 0-7.814-.418a2.506 2.506 0 0 1-1.768-1.768C2 15.22 2 12 2 12s0-3.22.418-4.814a2.506 2.506 0 0 1 1.768-1.768C5.78 5 12 5 12 5s6.22 0 7.812.418ZM15.194 12 10 15.194V8.806L15.194 12Z'
    ],
    [
        'href' => 'https://www.tiktok.com/@gladyswanga043',
        'label' => 'Follow on TikTok',
        'icon' => 'M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.04-5.36Z'
    ]
];
?>

</main> <footer class="bg-gradient-to-br from-brand-blue to-blue-900 text-white dark:bg-gradient-to-br dark:from-dark-bg dark:to-gray-900 dark:border-t dark:border-gray-700" aria-labelledby="footer-heading">
    <h2 id="footer-heading" class="sr-only">Footer</h2>
    
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-10">
            
            <div class="footer-fade-in-section">
                <h3 class="text-xl font-bold mb-4">Genowa Delivery Unit</h3>
                <p class="text-gray-200 dark:text-gray-400">A commitment to transparency and accountability in Homa Bay County's development agenda under the leadership of Governor Gladys Wanga.</p>
            </div>

            <div class="footer-fade-in-section">
                <h3 class="text-lg font-semibold mb-4">Quick Links</h3>
                <ul class="space-y-2">
                    <?php foreach ($footer_links as $link): ?>
                        <li>
                            <a href="<?php echo e($link['href']); ?>"
                               class="hover:text-brand-orange transition duration-300 text-gray-200 dark:text-gray-300"
                               <?php if (!empty($link['external'])) echo 'target="_blank" rel="noopener noreferrer"'; ?>>
                                <?php echo e($link['label']); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>

            <div class="footer-fade-in-section">
                <h3 class="text-lg font-semibold mb-4">Manifesto Pillars</h3>
                <ul class="space-y-2 text-gray-200 dark:text-gray-400">
                    <?php 
                    $pillars = ['Health Services', 'Water & Environment', 'Infrastructure & ICT', 'Agriculture & Food Security', 'Education & Social Services'];
                    foreach($pillars as $pillar): ?>
                        <li><span class="text-brand-orange mr-2">✓</span><?php echo e($pillar); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>

            <div class="footer-fade-in-section">
                <h3 class="text-lg font-semibold mb-4">Get In Touch</h3>
                <address class="not-italic text-gray-200 dark:text-gray-400">
                    <p>Homa Bay County Government</p>
                    <p>P.O. Box 469 – 40300, Homa Bay</p>
                    <a href="mailto:hello@genowa.co.ke" class="hover:text-brand-orange transition duration-300 block mt-2">hello@genowa.co.ke</a>
                </address>
            </div>
        </div>

        <div class="mt-16 border-t-2 border-brand-orange pt-8 flex flex-col sm:flex-row justify-between items-center">
            <p class="text-sm text-gray-400 text-center sm:text-left mb-4 sm:mb-0">© <?php echo date('Y'); ?> Genowa Delivery Unit | A Homa Bay County Initiative</p>
            <div class="flex items-center space-x-6">
                 <?php foreach ($social_links as $social): ?>
                    <a href="<?php echo e($social['href']); ?>" target="_blank" rel="noopener noreferrer" aria-label="<?php echo e($social['label']); ?>" class="text-gray-300 hover:text-brand-orange transition-colors">
                        <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24"><path fill-rule="evenodd" d="<?php echo $social['icon']; ?>" clip-rule="evenodd" /></svg>
                    </a>
                 <?php endforeach; ?>
            </div>
        </div>
    </div>
</footer>

<div class="fixed bottom-5 right-5 z-40 group flex items-center">
    <div class="hidden lg:block mr-4 p-3 bg-white dark:bg-gray-800 text-brand-blue dark:text-white rounded-lg shadow-lg transition-all duration-300 opacity-0 group-hover:opacity-100 -translate-x-4 group-hover:translate-x-0">
        <p class="font-semibold">Ask me anything!</p>
    </div>
    <button id="chat-toggle-btn" 
            class="bg-brand-blue text-white rounded-full p-4 shadow-lg hover:bg-brand-orange transition-colors focus:outline-none focus:ring-2 focus:ring-brand-orange focus:ring-offset-2" 
            aria-label="Toggle Chatbot" 
            aria-controls="chat-iframe-container" 
            aria-pressed="false">
        <svg id="chat-open-icon" xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 block" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" /></svg>
        <svg id="chat-close-icon" xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" /></svg>
    </button>
</div>

<div id="chat-iframe-container" class="hidden fixed bottom-24 right-5 z-40 h-[65vh] w-96 lg:h-[70vh] lg:w-[448px] transition-all duration-300 ease-in-out">
    </div>

<button id="back-to-top" class="hidden fixed bottom-5 left-5 z-40 bg-brand-orange text-white rounded-full p-3 shadow-lg hover:bg-opacity-90 transition-opacity focus:outline-none focus:ring-2 focus:ring-brand-orange focus:ring-offset-2" aria-label="Back to Top">
    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" /></svg>
</button>

<script src="/admin/assets/js/footer.js" defer></script>

</body>
</html>