<?php
// FILE: public_html/db_connect.php
// PURPOSE: Establishes a PDO database connection for the public-facing website.
// It securely accesses the configuration from within the admin directory.

// Define the path to the configuration file relative to this script's location.
// This is a secure way to access config without exposing directory structures.
$config_path = __DIR__ . '/admin/config.ini';

// Read configuration from .ini file
$config = @parse_ini_file($config_path, true);
if (!$config) {
    // In a production environment, you should log this error and show a user-friendly message.
    http_response_code(503); // Service Unavailable
    die("Error: The service is temporarily unavailable. Unable to read site configuration.");
}

$db_config = $config['database'];

$host = $db_config['host'];
$dbname = $db_config['dbname'];
$user = $db_config['user'];
$pass = $db_config['password'];
$charset = $db_config['charset'];

// Data Source Name (DSN)
$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";

// PDO Options
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    // Create a new PDO instance
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    // If the connection fails, show a generic error to the public.
    // The actual error should be logged for the administrator to review.
    error_log("Public Site Database Connection Error: " . $e->getMessage());
    http_response_code(503);
    die("Error: A database connection could not be established. The service is temporarily down for maintenance.");
}
//Load GPT configuration
$gpt_config       = $config['gpt'];
$gpt_model        = $gpt_config['model'];
$gpt_temperature  = floatval($gpt_config['temperature']);
$gpt_max_tokens   = intval($gpt_config['max_tokens']);

// Example usage: preparing a GPT API payload
$messages = $conversationHistory ?? []; // Placeholder for actual history logic
$messages[] = ['role' => 'system', 'content' => $systemMessage ?? ''];
$messages[] = ['role' => 'user', 'content' => $finalUserMessage ?? ''];

$data = [
    'model'       => $gpt_model,
    'messages'    => $messages,
    'temperature' => $gpt_temperature,
    'max_tokens'  => $gpt_max_tokens,
];