<?php
// FILE: chat_handler.php (UPDATED)

// Set the content type to application/json for the response
header('Content-Type: application/json');

// --- SHARED LOGIC & CONFIGURATION ---
// This file now includes 'db_connect.php' internally, giving it access
// to the database ($pdo) and configuration ($config) automatically.
require_once 'bot_core_logic.php';

// --- INPUT PROCESSING ---
$input = json_decode(file_get_contents('php://input'), true);
$userMessage = trim($input['message'] ?? '');
$language = $input['language'] ?? 'en-US'; 
$conversationHistory = $input['history'] ?? []; // Support for conversation history

if (empty($userMessage)) {
    echo json_encode(['reply' => 'I did not receive a message. Please try again.']);
    exit;
}

// --- GET BOT RESPONSE ---
// Call the shared function with the new, simplified signature.
// We no longer pass $pdo or $apiKey, as the function gets them automatically.
$botReply = getBotResponse($userMessage, $conversationHistory, $language);

// --- SEND RESPONSE ---
echo json_encode(['reply' => $botReply]);
?>