<?php
// This is a utility script to create test users.
// Upload it to your /blogger/ directory, run it once, and then DELETE IT IMMEDIATELY.

// Include the database connection
require_once 'includes/db.php';

// Simple HTML styling for output
echo "<!DOCTYPE html><html lang='en'><head><meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>Test User Creation</title>";
echo "<style>
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; line-height: 1.6; padding: 20px; max-width: 800px; margin: auto; background-color: #f9f9f9; color: #333; }
        .container { background: #fff; border-radius: 8px; padding: 20px 30px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        h2 { border-bottom: 2px solid #eee; padding-bottom: 10px; }
        .success { color: #28a745; font-weight: bold; }
        .error { color: #dc3545; font-weight: bold; }
        .info { color: #007bff; }
        .danger { background: #ffcccc; border: 1px solid #dc3545; padding: 15px; border-radius: 5px; font-weight: bold; margin-top: 20px; text-align: center; }
        ul { list-style-type: none; padding-left: 0; }
        li { background: #f1f1f1; padding: 10px; border-radius: 4px; margin-bottom: 8px; }
        code { background: #e9e9e9; padding: 2px 5px; border-radius: 3px; }
      </style>";
echo "</head><body><div class='container'>";
echo "<h2>Genowa Test User Creation Script</h2>";

try {
    $db = getDB();

    // --- 1. Create Test Supervisor ---
    $supervisor_email = 'supervisor@test.com';
    $supervisor_pass = 'password123';
    $hashed_pass_sup = password_hash($supervisor_pass, PASSWORD_DEFAULT);

    // Check if supervisor exists
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$supervisor_email]);
    $supervisor = $stmt->fetch();

    $supervisor_id = null;

    if ($supervisor) {
        echo "<p class='info'>Supervisor <code>{$supervisor_email}</code> already exists. Skipping creation.</p>";
        $supervisor_id = $supervisor['id'];
    } else {
        // Create supervisor
        $stmt = $db->prepare("INSERT INTO users (email, password, role, status, supervisorId) VALUES (?, ?, 'supervisor', 'approved', NULL)");
        $stmt->execute([$supervisor_email, $hashed_pass_sup]);
        $supervisor_id = $db->lastInsertId();
        echo "<p class='success'>Successfully created SUPERVISOR:</p>";
        echo "<ul><li>Email: <strong>{$supervisor_email}</strong></li><li>Password: <strong>{$supervisor_pass}</strong></li></ul>";
    }

    // --- 2. Create Test Blogger (linked to Supervisor) ---
    $blogger_email = 'blogger@test.com';
    $blogger_pass = 'password123';
    $hashed_pass_blog = password_hash($blogger_pass, PASSWORD_DEFAULT);

    // Check if blogger exists
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->execute([$blogger_email]);
    $blogger = $stmt->fetch();

    if ($blogger) {
        echo "<p class='info'>Blogger <code>{$blogger_email}</code> already exists. Skipping creation.</p>";
        
        // Quick check to see if they are linked correctly
        $stmtCheck = $db->prepare("SELECT supervisorId FROM users WHERE id = ?");
        $stmtCheck->execute([$blogger['id']]);
        if ($stmtCheck->fetchColumn() != $supervisor_id) {
             echo "<p class='error'>Warning: This blogger exists but is NOT linked to <code>{$supervisor_email}</code>. You may need to update them in phpMyAdmin.</p>";
        }

    } else {
        // Create blogger and link them to the supervisor
        $stmt = $db->prepare("INSERT INTO users (email, password, role, status, supervisorId) VALUES (?, ?, 'blogger', 'approved', ?)");
        $stmt->execute([$blogger_email, $hashed_pass_blog, $supervisor_id]);
        echo "<p class='success'>Successfully created BLOGGER:</p>";
        echo "<ul><li>Email: <strong>{$blogger_email}</strong></li><li>Password: <strong>{$blogger_pass}</strong></li><li>Linked to Supervisor: <strong>{$supervisor_email}</strong></li></ul>";
    }

    echo "<h3 class='danger'>CRITICAL: For security, please delete this file (<code>create_test_users.php</code>) from your server NOW.</h3>";

} catch (PDOException $e) {
    echo "<p class='error'>DATABASE ERROR: " . $e->getMessage() . "</p>";
    echo "<p>Please ensure your database credentials in <code>includes/db.php</code> are correct and the database is running.</p>";
}

echo "</div></body></html>";
?>
