<?php
// FILE: templates/header.php
// This file includes the main layout, sidebar, and top mobile/desktop nav.

// Get the current page for 'active' link styling
$current_page = $_GET['page'] ?? 'dashboard';

// Determine the greeting
$hour = (int)date('H'); // 24-hour format in UTC
$greeting = "Good morning";
if ($hour >= 12 && $hour < 17) {
    $greeting = "Good afternoon";
} elseif ($hour >= 17 || $hour < 4) {
    $greeting = "Good evening";
}

// Get user name from session
$user_name_display = $_SESSION['user_name'] ?? $_SESSION['user_email'];
if (empty(trim($user_name_display))) {
    $user_name_display = $_SESSION['user_email'];
}

?>
<!DOCTYPE html>
<html lang="en" class="h-full bg-gray-100">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Genowa Portal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        [x-cloak] { display: none !important; }
        
        /* Custom scrollbar */
        .sidebar-scroll::-webkit-scrollbar {
            width: 6px;
        }
        .sidebar-scroll::-webkit-scrollbar-track {
            background: #1f2937; /* dark-gray-800 */
        }
        .sidebar-scroll::-webkit-scrollbar-thumb {
            background: #4b5563; /* dark-gray-600 */
            border-radius: 3px;
        }
        .sidebar-scroll::-webkit-scrollbar-thumb:hover {
            background: #6b7280; /* dark-gray-500 */
        }
        
        /* Custom styles for the styled logo */
        .logo-text-blue {
            color: #0052A4;
        }
        .logo-text-orange {
            color: #F58220;
        }
        
        /* Form styling for profile/review pages */
        .form-label {
            @apply block mb-2 text-sm font-medium text-gray-700;
        }
        .form-label .required-star {
            @apply text-red-500 ml-1;
        }
        .form-input-wrapper {
            @apply relative;
        }
        .form-input-icon {
            @apply absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none;
        }
        .form-input {
            @apply block w-full px-4 py-3 text-sm text-gray-900 bg-white border border-gray-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-500 focus:outline-none;
        }
        /* Profile page inputs don't have icons */
        #my_profile .form-input {
            @apply pl-4;
        }
    </style>
</head>
<body class="h-full">

<div x-data="{ sidebarOpen: false }">
    <!-- Off-canvas menu for mobile -->
    <div x-show="sidebarOpen" class="fixed inset-0 flex z-40 md:hidden" 
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         x-cloak>
        
        <!-- Off-canvas menu overlay -->
        <div @click="sidebarOpen = false" class="fixed inset-0 bg-gray-600 bg-opacity-75" aria-hidden="true"></div>
        
        <!-- Off-canvas menu -->
        <div class="relative flex-1 flex flex-col max-w-xs w-full bg-gray-800 text-white"
             x-transition:enter="transition ease-in-out duration-300 transform"
             x-transition:enter-start="-translate-x-full"
             x-transition:enter-end="translate-x-0"
             x-transition:leave="transition ease-in-out duration-300 transform"
             x-transition:leave-start="translate-x-0"
             x-transition:leave-end="-translate-x-full">
            
            <!-- Close button -->
            <div class="absolute top-0 right-0 -mr-12 pt-2">
                <button @click="sidebarOpen = false" type="button" class="ml-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white">
                    <span class="sr-only">Close sidebar</span>
                    <i class="fas fa-times text-white"></i>
                </button>
            </div>

            <!-- Sidebar header (mobile) -->
            <div class="flex-shrink-0 flex items-center px-4 h-16 bg-gray-900">
                <a href="index.php" class="flex items-center space-x-2">
                    <span class="text-3xl">
                        <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M12 14l9-5-9-5-9 5 9 5z" fill="#F58220"/><path d="M12 14l6.16-3.422a.997.997 0 00.518-1.342.997.997 0 00-1.342-.518L12 11.5 6.664 8.718a.997.997 0 00-1.342.518c-.22.396-.1.884.28 1.18l6.4 3.584z" fill="#0052A4" opacity="0.6"/><path d="M12 21l-9-5v-6l9 5 9-5v6l-9 5z" fill="#0052A4"/><path d="M12 21l6.16-3.422a.997.997 0 00.518-1.342.997.997 0 00-1.342-.518L12 18.5l-5.336-2.782a.997.997 0 00-1.342.518c-.22.396-.1.884.28 1.18l6.4 3.584z" fill="#F58220" opacity="0.6"/></svg>
                    </span>
                    <span class="text-2xl font-extrabold text-white">Genowa <span class="logo-text-orange">Portal</span></span>
                </a>
            </div>
            
            <!-- Sidebar navigation (mobile) -->
            <div class="mt-5 flex-1 h-0 overflow-y-auto sidebar-scroll">
                <?php require 'templates/sidebar_nav.php'; ?>
            </div>
        </div>
        <div class="flex-shrink-0 w-14" aria-hidden="true"></div>
    </div>

    <!-- Static sidebar for desktop -->
    <div class="hidden md:flex md:flex-col md:fixed md:inset-y-0 md:w-64">
        <div class="flex flex-col flex-grow bg-gray-900 pt-5 overflow-y-auto sidebar-scroll">
            
            <!-- Sidebar header (desktop) -->
            <div class="flex items-center flex-shrink-0 px-4">
                <a href="index.php" class="flex items-center space-x-2">
                    <span class="text-3xl">
                        <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M12 14l9-5-9-5-9 5 9 5z" fill="#F58220"/><path d="M12 14l6.16-3.422a.997.997 0 00.518-1.342.997.997 0 00-1.342-.518L12 11.5 6.664 8.718a.997.997 0 00-1.342.518c-.22.396-.1.884.28 1.18l6.4 3.584z" fill="#0052A4" opacity="0.6"/><path d="M12 21l-9-5v-6l9 5 9-5v6l-9 5z" fill="#0052A4"/><path d="M12 21l6.16-3.422a.997.997 0 00.518-1.342.997.997 0 00-1.342-.518L12 18.5l-5.336-2.782a.997.997 0 00-1.342.518c-.22.396-.1.884.28 1.18l6.4 3.584z" fill="#F58220" opacity="0.6"/></svg>
                    </span>
                    <span class="text-2xl font-extrabold text-white">Genowa <span class="logo-text-orange">Portal</span></span>
                </a>
            </div>
            
            <!-- Sidebar navigation (desktop) -->
            <div class="mt-5 flex-1 flex flex-col">
                <?php require 'templates/sidebar_nav.php'; ?>
            </div>
        </div>
    </div>

    <!-- Main content area -->
    <div class="md:pl-64 flex flex-col flex-1">
        
        <!-- Top bar -->
        <div class="sticky top-0 z-10 flex-shrink-0 flex h-16 bg-white shadow">
            
            <!-- Mobile menu button -->
            <button @click.stop="sidebarOpen = true" type="button" class="px-4 border-r border-gray-200 text-gray-500 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500 md:hidden">
                <span class="sr-only">Open sidebar</span>
                <i class="fas fa-bars h-6 w-6"></i>
            </button>
            
            <!-- Top bar content -->
            <div class="flex-1 px-4 flex justify-between">
                <div class="flex-1 flex">
                    <!-- Search bar (optional) -->
                </div>
                <div class="ml-4 flex items-center md:ml-6">
                    <div class="text-right">
                        <p class="text-sm font-medium text-gray-800">
                            <?php echo $greeting; ?>, <?php echo htmlspecialchars(explode(' ', $user_name_display)[0]); ?>
                        </p>
                        <p class="text-xs text-gray-500">
                            <?php echo htmlspecialchars($_SESSION['user_email']); ?>
                            (<?php echo htmlspecialchars(ucfirst($_SESSION['user_role'])); ?>)
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main page content -->
        <main class="flex-1 py-8 px-4 sm:px-6 md:px-8">
            <div class="max-w-7xl mx-auto">
                <!-- Content goes here -->

