<?php
// Enable error display
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Validation and success message variables
$success_message = "";
$error_message = "";

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Get and sanitize inputs
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = trim($_POST['password'] ?? '');

    // Validation
    if (empty($name) || empty($email) || empty($phone) || empty($password)) {
        $error_message = "All fields are required.";
    } elseif (!preg_match("/^[a-zA-Z ]+$/", $name)) {
        $error_message = "Name should only contain letters and spaces.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error_message = "Invalid email address.";
    } elseif (!preg_match("/^(07|01)[0-9]{8}$/", $phone)) {
        $error_message = "Phone number must start with 07 or 01 and be 10 digits.";
    } elseif (strlen($password) < 6) {
        $error_message = "Password must be at least 6 characters.";
    } else {
        // If everything is valid
        $success_message = "✅ Registration successful!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>User Registration</title>
<script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">

<div class="bg-white p-8 rounded-2xl shadow-lg w-full max-w-md">
    <h2 class="text-2xl font-bold text-center mb-6 text-blue-700">User Registration</h2>

    <?php if (!empty($error_message)): ?>
        <div class="bg-red-100 text-red-700 p-3 rounded mb-4"><?= htmlspecialchars($error_message) ?></div>
    <?php elseif (!empty($success_message)): ?>
        <div class="bg-green-100 text-green-700 p-3 rounded mb-4"><?= htmlspecialchars($success_message) ?></div>
    <?php endif; ?>

    <form method="POST" action="" class="space-y-4">
        <div>
            <label class="block font-medium mb-1">Full Name</label>
            <input type="text" name="name" required
                class="w-full border border-gray-300 rounded px-3 py-2 focus:ring-2 focus:ring-blue-500"
                value="<?= htmlspecialchars($_POST['name'] ?? '') ?>">
        </div>

        <div>
            <label class="block font-medium mb-1">Email</label>
            <input type="email" name="email" required
                class="w-full border border-gray-300 rounded px-3 py-2 focus:ring-2 focus:ring-blue-500"
                value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
        </div>

        <div>
            <label class="block font-medium mb-1">Phone Number</label>
            <input type="text" name="phone" required pattern="^(07|01)[0-9]{8}$"
                class="w-full border border-gray-300 rounded px-3 py-2 focus:ring-2 focus:ring-blue-500"
                value="<?= htmlspecialchars($_POST['phone'] ?? '') ?>">
        </div>

        <div>
            <label class="block font-medium mb-1">Password</label>
            <input type="password" name="password" required minlength="6"
                class="w-full border border-gray-300 rounded px-3 py-2 focus:ring-2 focus:ring-blue-500">
        </div>

        <button type="submit"
            class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 rounded-lg font-semibold">
            Submit
        </button>
    </form>
</div>

</body>
</html>
