<?php
// FILE: pages/view_post.php

$post_id = (int)($_GET['id'] ?? 0);
$post = null;

if ($post_id > 0) {
    $post = getSinglePost($post_id, $_SESSION['user_id']);
}

// We only show the error or content *after* the header is included.
// This file is included *by* index.php, which handles the header.
// So, we just need to check if $post is valid.

if (!$post):
    // If post is not found or ID is invalid, show an error message.
?>
    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded-lg" role="alert">
        <h2 class="text-xl font-bold mb-2">Post Not Found</h2>
        <p>The post you are looking for does not exist or may have been removed.</p>
        <a href="index.php?page=feed" class="inline-block mt-4 bg-red-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-red-700 transition-colors">
            <i class="fas fa-arrow-left mr-2"></i>
            Back to Community Feed
        </a>
    </div>
<?php
else:
    // Post was found, so get comments
    $comments = getCommentsForPost($post_id);
    $user_has_liked = $post['userHasLiked'];
    $like_count = $post['likeCount'];
    $comment_count = $post['commentCount'];
?>
<div class="bg-white rounded-xl shadow-lg overflow-hidden">
    <div class="p-6 md:p-8">
        
        <!-- Post Header -->
        <div class="mb-6">
            <p class="text-sm text-gray-500 mb-2">
                Posted by <span class="font-medium text-gray-900"><?php echo htmlspecialchars($post['bloggerEmail']); ?></span>
                on <?php echo date('M d, Y', strtotime($post['submittedAt'])); ?>
            </p>
            <h1 class="text-3xl font-extrabold text-gray-900 mb-2">View Post Details</h1>
            <p class="text-lg text-gray-700">
                <a href="<?php echo htmlspecialchars($post['url']); ?>" target="_blank" rel="noopener noreferrer" class="text-blue-600 hover:text-blue-800 hover:underline break-all">
                    <?php echo htmlspecialchars($post['url']); ?>
                    <i class="fas fa-external-link-alt text-sm ml-1"></i>
                </a>
            </p>
        </div>

        <!-- Post Stats -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8 text-center">
            <div class="bg-gray-100 p-4 rounded-lg">
                <span class="text-2xl font-bold text-blue-600"><?php echo number_format($post['reach'] ?? 0); ?></span>
                <span class="text-sm text-gray-600 block">Reach</span>
            </div>
            <div class="bg-gray-100 p-4 rounded-lg">
                <span class="text-2xl font-bold text-red-600"><?php echo number_format($post['likes'] ?? 0); ?></span>
                <span class="text-sm text-gray-600 block">Likes</span>
            </div>
            <div class="bg-gray-100 p-4 rounded-lg">
                <span class="text-2xl font-bold text-green-600"><?php echo number_format($post['comments'] ?? 0); ?></span>
                <span class="text-sm text-gray-600 block">Comments</span>
            </div>
            <div class="bg-gray-100 p-4 rounded-lg">
                <span class="text-2xl font-bold text-purple-600"><?php echo number_format($post['shares'] ?? 0); ?></span>
                <span class="text-sm text-gray-600 block">Shares</span>
            </div>
        </div>
        
        <!-- Like Button -->
        <form action="index.php?action=like_post" method="POST" class="mb-8">
            <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">
            <input type="hidden" name="return_post_id" value="<?php echo $post_id; ?>">
            <button type="submit" class="w-full md:w-auto px-6 py-3 rounded-lg font-semibold transition-colors
                <?php if ($user_has_liked): ?>
                    bg-red-600 text-white hover:bg-red-700
                <?php else: ?>
                    bg-red-100 text-red-700 hover:bg-red-200
                <?php endif; ?>
            ">
                <i class="fas fa-heart mr-2"></i>
                <?php if ($user_has_liked): ?>
                    Unlike (<?php echo $like_count; ?>)
                <?php else: ?>
                    Like (<?php echo $like_count; ?>)
                <?php endif; ?>
            </button>
        </form>

        <!-- Comments Section -->
        <div>
            <h2 class="text-2xl font-bold text-gray-800 mb-6">
                Community Comments (<?php echo $comment_count; ?>)
            </h2>

            <!-- Add Comment Form -->
            <form action="index.php?action=add_comment" method="POST" class="mb-8">
                <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">
                <input type="hidden" name="post_id" value="<?php echo $post_id; ?>">
                <div>
                    <label for="comment_text" class="block text-sm font-medium text-gray-700 sr-only">Add your comment</label>
                    <textarea id="comment_text" name="comment_text" rows="4" class="shadow-sm block w-full sm:text-sm border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500" placeholder="Add your peer review comment..." required></textarea>
                </div>
                <div class="mt-3">
                    <button type="submit" class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-base font-medium rounded-lg shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        Post Comment
                    </button>
                </div>
            </form>

            <!-- List Comments -->
            <div class="space-y-6">
                <?php if (empty($comments)): ?>
                    <p class="text-gray-500">Be the first to comment on this post.</p>
                <?php else: ?>
                    <?php foreach ($comments as $comment): ?>
                        <div class="flex space-x-4">
                            <div class="flex-shrink-0">
                                <span class="inline-block h-10 w-10 rounded-full overflow-hidden bg-gray-100">
                                    <svg class="h-full w-full text-gray-300" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M24 20.993V24H0v-2.996A14.977 14.977 0 0112.004 15c4.904 0 9.26 2.354 11.996 5.993zM16.002 8.999a4 4 0 11-8 0 4 4 0 018 0z" />
                                    </svg>
                                </span>
                            </div>
                            <div class="flex-1">
                                <div class="bg-gray-100 rounded-lg px-4 py-3">
                                    <div class="flex items-baseline justify-between">
                                        <p class="text-sm font-medium text-gray-900">
                                            <?php echo htmlspecialchars($comment['authorEmail']); ?>
                                        </p>
                                        <p class="text-xs text-gray-500">
                                            <?php echo date('M d, Y \a\t H:i', strtotime($comment['createdAt'])); ?>
                                        </p>
                                    </div>
                                    <p class="text-gray-800 mt-2">
                                        <?php echo nl2br(htmlspecialchars($comment['comment_text'])); ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php
endif; // End of if($post)
?>

