<?php
// FILE: pages/submit_post.php
// This is the content for the post submission page.

// We need the CSRF token function
// Note: functions.php is already included by index.php, so $csrfToken is available
?>

<div>
    <h1 class="text-3xl font-bold text-gray-900 mb-6">Submit a New Post</h1>

    <div class="max-w-xl mx-auto bg-white p-8 rounded-lg shadow-md">
        <form action="index.php" method="POST">
            <!-- Hidden inputs for action and CSRF token -->
            <input type="hidden" name="action" value="submit_post">
            <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">

            <div class="space-y-6">
                <!-- Post URL -->
                <div>
                    <label for="url" class="block text-sm font-medium text-gray-700 mb-1">
                        Post URL
                    </label>
                    <div class="mt-1">
                        <input type="url" name="url" id="url" 
                               class="block w-full px-4 py-3 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-green-500 focus:border-green-500 sm:text-sm" 
                               placeholder="https://www.yourblog.com/your-post-title" 
                               required>
                    </div>
                    <p class="mt-2 text-xs text-gray-500">
                        Enter the full URL of your blog post, Facebook post, or other link.
                    </p>
                </div>
                
                <!-- Submit Button -->
                <div>
                    <button type="submit" 
                            class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition-colors duration-200">
                        <i class="fas fa-paper-plane mr-2"></i>
                        Submit for Review
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

