<?php
// FILE: pages/review_posts.php
// This page is now for *Initial Approval* only.

// 1. Security Check: Only Supervisors and Admins can access this page
checkSupervisor();

// 2. Get Data: Fetch all posts with the status 'pending'
$pending_posts = getPendingPostsForSupervisor($_SESSION['user_id'], $_SESSION['user_role']);

// 3. Get CSRF token
$csrfToken = getCSRFToken();
?>

<h2 class="text-3xl font-semibold text-gray-800 mb-6">Review Pending Posts</h2>

<?php if (empty($pending_posts)): ?>
    <!-- Message if the queue is empty -->
    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded-lg">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-info-circle text-blue-500"></i>
            </div>
            <div class="ml-3">
                <p class="text-sm text-blue-700">
                    The initial review queue is empty.
                </p>
            </div>
        </div>
    </div>
<?php else: ?>
    <!-- Responsive Table for Review Queue -->
    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Blogger
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Post URL
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Submitted
                        </th>
                        <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php foreach ($pending_posts as $post): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($post['bloggerEmail']); ?></div>
                            </td>
                            <td class="px-6 py-4 max-w-sm">
                                <a href="<?php echo htmlspecialchars($post['url']); ?>" target="_blank" rel="noopener noreferrer" class="text-sm text-blue-600 hover:text-blue-800 break-all truncate">
                                    <?php echo htmlspecialchars($post['url']); ?>
                                </a>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-500"><?php echo date("M j, Y - g:ia", strtotime($post['submittedAt'])); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-2 flex items-center justify-end">
                                <!-- Approve Form -->
                                <form action="index.php?action=approve_post" method="POST" class="inline-block">
                                    <input type="hidden" name="csrf_token" value="<?php echo $csrfToken; ?>">
                                    <input type="hidden" name="post_id" value="<?php echo $post['id']; ?>">
                                    <button type.="submit" class="text-green-600 hover:text-green-900 px-3 py-1 bg-green-100 rounded-full text-xs font-bold">
                                        Approve
                                    </button>
                                </form>
                                <!-- Reject Form -->
                                <form action="index.php?action=reject_post" method="POST" class="inline-block">
                                    <input type="hidden" name="csrf_token" value="<?php echo $csrfToken; ?>">
                                    <input type="hidden" name="post_id" value="<?php echo $post['id']; ?>">
                                    <button type.="submit" class="text-red-600 hover:text-red-900 px-3 py-1 bg-red-100 rounded-full text-xs font-bold">
                                        Reject
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php endif; ?>

