<?php
// FILE: pages/my_profile.php
// This page allows users to edit their own profile.
// It's also the landing page for pending users.

// 1. Get User's Current Data
$user_id = $_SESSION['user_id'];
$user_profile = getUserProfile($user_id); // New function in functions.php
$user_socials = getUserSocials($user_id); // New function in functions.php

// Create an Alpine.js-compatible array of socials
$socials_json = '[]';
if (!empty($user_socials)) {
    // We need to map the keys to match the Alpine component
    $alpine_socials = [];
    foreach ($user_socials as $social) {
        $alpine_socials[] = [
            'id' => $social['id'], // Include ID for updates
            'platform' => $social['platform'],
            'url' => $social['url'],
            'followers' => $social['followers'],
            'is_verified' => (bool)$social['is_verified'],
        ];
    }
    // Need to properly escape for use in an HTML attribute
    $socials_json = htmlspecialchars(json_encode($alpine_socials), ENT_QUOTES, 'UTF-8');
}

?>

<div class="space-y-8" 
     x-data="{ 
        role: '<?php echo htmlspecialchars($user_profile['role']); ?>',
        socials: <?php echo html_entity_decode($socials_json); ?>,
        addSocial() {
            this.socials.push({ id: null, platform: 'tiktok', url: '', followers: '', is_verified: false });
        },
        removeSocial(index) {
            this.socials.splice(index, 1);
        }
     }"
>
    <h1 class="text-3xl font-bold text-gray-800">My Profile</h1>

    <!-- Status Alert -->
    <?php if ($user_profile['status'] !== 'approved'): ?>
        <div class="p-4 bg-blue-100 border-l-4 border-blue-500 text-blue-700 rounded-lg" role="alert">
            <p class="font-bold">Your Account is Pending Approval</p>
            <p>
                <?php if ($user_profile['status'] === 'pending_admin'): ?>
                    An administrator is currently reviewing your supervisor application.
                <?php else: ?>
                    Your supervisor is currently reviewing your application.
                <?php endif; ?>
            </p>
            <p class="mt-2">In the meantime, you can review and update your profile details below.</p>
        </div>
    <?php endif; ?>


    <!-- Profile Edit Form -->
    <form action="index.php?page=my_profile" method="POST">
        <input type="hidden" name="action" value="update_profile">
        <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">

        <div class="bg-white rounded-xl shadow-lg overflow-hidden">
            <div class="p-6 sm:p-8 border-b border-gray-200">
                <h2 class="text-xl font-semibold text-gray-700">Personal & Payment Details</h2>
                <p class="mt-1 text-sm text-gray-500">
                    Keep your information up to date. Your payment number is crucial for receiving earnings.
                </p>
            </div>
            
            <div class="p-6 sm:p-8 space-y-6" id="my_profile">
                <!-- Row 1: Name & Email -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="name" class="form-label">Full Name<span class="required-star">*</span></label>
                        <input type="text" id="name" name="name" class="form-input" value="<?php echo htmlspecialchars($user_profile['name']); ?>" required>
                    </div>
                    <div>
                        <label for="email" class="form-label">Email Address (Cannot be changed)</label>
                        <input type="email" id="email" name="email" class="form-input bg-gray-100" value="<?php echo htmlspecialchars($user_profile['email']); ?>" readonly disabled>
                    </div>
                </div>

                <!-- Row 2: Phone & Payment -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="phone_number" class="form-label">Phone Number<span class="required-star">*</span></label>
                        <input type="tel" id="phone_number" name="phone_number" class="form-input" value="<?php echo htmlspecialchars($user_profile['phone_number']); ?>" required>
                    </div>
                    <div>
                        <label for="payment_number" class="form-label">Payment Number (M-Pesa)<span class="required-star">*</span></label>
                        <input type="tel" id="payment_number" name="payment_number" class="form-input" value="<?php echo htmlspecialchars($user_profile['payment_number']); ?>" required>
                    </div>
                </div>

                <!-- Row 3: Location & Expertise -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="location" class="form-label">Location (County)<span class="required-star">*</span></label>
                        <input type="text" id="location" name="location" class="form-input" value="<?php echo htmlspecialchars($user_profile['location']); ?>" required>
                    </div>
                    <div>
                        <label for="expertise" class="form-label">Interests / Expertise</label>
                        <input type="text" id="expertise" name="expertise" class="form-input" value="<?php echo htmlspecialchars($user_profile['expertise']); ?>" placeholder="e.g., Politics, Tech, Lifestyle">
                    </div>
                </div>

                <!-- Row 4: Bio -->
                <div>
                    <label for="bio" class="form-label">Short Bio</label>
                    <textarea id="bio" name="bio" rows="4" class="form-input" placeholder="Tell us about yourself..."><?php echo htmlspecialchars($user_profile['bio']); ?></textarea>
                </div>
            </div>

            <!-- Social Media Section (Blogger Only) -->
            <div x-show="role === 'blogger'" x-cloak>
                <div class="p-6 sm:p-8 border-t border-gray-200">
                    <h2 class="text-xl font-semibold text-gray-700">Social Media Channels</h2>
                    <p class="mt-1 text-sm text-gray-500">
                        Keep your social media links and follower counts up to date.
                    </p>
                </div>
                
                <div class="p-6 sm:p-8 pt-0 space-y-6">
                    <template x-for="(social, index) in socials" :key="index">
                        <div class="p-4 border rounded-lg space-y-4 relative">
                            <input type="hidden" :name="'socials[' + index + '][id]'" :value="social.id">
                            <button type="button" @click="removeSocial(index)" class="absolute -top-2 -right-2 w-7 h-7 bg-red-500 text-white rounded-full hover:bg-red-600 focus:outline-none" title="Remove channel">
                                &times;
                            </button>

                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                                <div>
                                    <label class="form-label">Platform</label>
                                    <select :name="'socials[' + index + '][platform]'" class="form-input" x-model="social.platform">
                                        <option value="facebook">Facebook</option>
                                        <option value="twitter">Twitter / X</option>
                                        <option value="tiktok">TikTok</option>
                                        <option value="instagram">Instagram</option>
                                        <option value="youtube">YouTube</option>
                                        <option value="blog">Blog / Website</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="form-label">Followers</label>
                                    <input type="number" :name="'socials[' + index + '][followers]'" class="form-input" placeholder="0" x-model="social.followers">
                                </div>
                            </div>

                            <div>
                                <label class="form-label">URL<span class="required-star">*</span></label>
                                <input type="url" :name="'socials[' + index + '][url]'" class="form-input" placeholder="https://..." required x-model="social.url">
                            </div>

                            <div class="flex items-center">
                                <input type="hidden" :name="'socials[' + index + '][is_verified]'" value="0">
                                <input type="checkbox" :name="'socials[' + index + '][is_verified]'" value="1" class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500" :checked="social.is_verified" x-model="social.is_verified">
                                <label class="ml-2 block text-sm text-gray-700">This account is verified</label>
                            </div>
                        </div>
                    </template>

                    <button type="button" @click="addSocial" class="w-full px-4 py-3 bg-gray-100 text-gray-700 font-medium rounded-lg hover:bg-gray-200">
                        <i class="fas fa-plus mr-2"></i> Add Another Channel
                    </button>
                </div>
            </div>


            <!-- Footer -->
            <div class="px-6 sm:px-8 py-4 bg-gray-50 border-t border-gray-200">
                <div class="flex justify-end">
                    <button type="submit" class="px-6 py-3 bg-blue-600 text-white font-medium rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-4 focus:ring-blue-300">
                        Save Changes
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

