<?php
// FILE: pages/feed.php

// Get all approved posts for the community feed
// This function will be updated to fetch metrics, not internal counts
$feed_posts = getCommunityFeed($_SESSION['user_id']);
?>

<div class="mx-auto max-w-3xl"> <!-- Fixed typo: removed extra 'class' -->
    <h1 class="text-3xl font-extrabold text-gray-900 mb-8">Community Feed</h1>

    <?php if (empty($feed_posts)): ?>
        <div class="bg-white rounded-xl shadow-lg p-8 text-center">
            <i class="fas fa-rss text-4xl text-gray-300 mb-4"></i>
            <h2 class="text-xl font-semibold text-gray-700">The feed is quiet...</h2>
            <p class="text-gray-500 mt-2">No posts have been approved for the community feed yet. Be the first!</p>
        </div>
    <?php else: ?>
        <div class="space-y-6">
            <?php foreach ($feed_posts as $post): ?>
                
                <!-- 
                  This is the new design. The entire <div> is inside an <a> tag.
                  This link now points to the EXTERNAL URL (Facebook, Twitter, etc.)
                  and opens in a new tab.
                -->
                <a href="<?php echo htmlspecialchars($post['url']); ?>" 
                   target="_blank" rel="noopener noreferrer"
                   class="block bg-white rounded-xl shadow-lg overflow-hidden transition-shadow duration-300 hover:shadow-xl">
                    
                    <div class="p-6">
                        <!-- Post Header -->
                        <div class="mb-4">
                            <p class="text-sm text-gray-500 mb-1">
                                Posted by <span class="font-medium text-gray-900"><?php echo htmlspecialchars($post['bloggerEmail']); ?></span>
                            </p>
                            <!-- The Post URL is the main, clickable title -->
                            <h2 class="text-lg font-semibold text-blue-600 hover:text-blue-800 hover:underline" title="View External Post">
                                <?php echo htmlspecialchars($post['url']); ?>
                            </h2>
                        </div>

                        <!-- Footer with Stats -->
                        <div class="flex justify-between items-center pt-4 border-t border-gray-100">
                            <!-- 
                              These stats now show the supervisor-entered metrics,
                              not internal counts.
                            -->
                            <div class="flex space-x-6">
                                <!-- Likes (from metrics) -->
                                <div class="flex items-center text-gray-500 space-x-2">
                                    <i class="fas fa-thumbs-up"></i>
                                    <span class="font-medium text-sm"><?php echo number_format($post['likes'] ?? 0); ?> Like<?php echo ($post['likes'] ?? 0) != 1 ? 's' : ''; ?></span>
                                </div>
                                <!-- Comments (from metrics) -->
                                <div class="flex items-center text-gray-500 space-x-2">
                                    <i class="fas fa-comment"></i>
                                    <span class="font-medium text-sm"><?php echo number_format($post['comments'] ?? 0); ?> Comment<?php echo ($post['comments'] ?? 0) != 1 ? 's' : ''; ?></span>
                                </div>
                            </div>
                            
                            <!-- Call to Action -->
                            <div class="flex items-center text-sm text-blue-600 font-semibold">
                                View & Interact Externally
                                <i class="fas fa-external-link-alt ml-2"></i>
                            </div>
                        </div>
                    </div>
                </a>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

