<?php
// File: public_html/api/save_constituency.php

header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
    exit;
}

// Get the raw POST data
$data = json_decode(file_get_contents('php://input'), true);
$constituencyId = $data['constituency_id'] ?? null;

// --- Define Secure Cookie Options ---
$cookieOptions = [
    'expires' => time() + (365 * 24 * 60 * 60), // 1 year from now
    'path' => '/',
    'domain' => '', // Leave empty for current host
    'secure' => true,   // IMPORTANT: Only send over HTTPS
    'httponly' => true, // IMPORTANT: Prevent JavaScript access
    'samesite' => 'Lax' // Good for CSRF protection
];

// --- LOGIC: Set or Clear the Cookie ---

// If constituencyId is empty, null, or 0, we clear the cookie
if (empty($constituencyId)) {
    $cookieOptions['expires'] = time() - 3600; // Set expiry in the past to delete
    setcookie('my_constituency_id', '', $cookieOptions);
    echo json_encode(['status' => 'success', 'message' => 'Constituency cleared.']);
    exit;
}

// If constituencyId is present, validate it as a positive integer
if (filter_var($constituencyId, FILTER_VALIDATE_INT, ['options' => ['min_range' => 1]])) {
    setcookie('my_constituency_id', $constituencyId, $cookieOptions);
    echo json_encode(['status' => 'success', 'message' => 'Constituency saved.']);
    exit;
}

// If validation fails
http_response_code(400); // Bad Request
echo json_encode(['status' => 'error', 'message' => 'Invalid constituency ID provided.']);
exit;