<?php
// FILE: admin/partials/project_photos_form.php
// PURPOSE: The form for uploading and managing project photos.
?>
<div class="bg-white rounded-lg shadow-lg p-8">
    <!-- Photo Upload Form - Correctly includes enctype -->
    <form action="manage_project.php?id=<?php echo e($project['id']); ?>#tab-photos" method="post" enctype="multipart/form-data" class="mb-12 border-b pb-8 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-brand-orange mb-4">Upload New Photo</h3>
        <?php if(isset($errors['project_photo'])): ?><p class="mb-4 text-sm text-red-600 bg-red-50 p-3 rounded-md"><?php echo $errors['project_photo']; ?></p><?php endif; ?>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 items-end">
            <div>
                <label for="photo_type" class="block text-sm font-bold text-brand-blue dark:text-gray-200 mb-1">Photo Type</label>
                <select name="photo_type" id="photo_type" required class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-2 px-4 py-3 text-base">
                    <option value="">Select Type</option>
                    <option value="Before">Before</option>
                    <option value="After">After</option>
                    <option value="Progress">Progress</option>
                </select>
                <?php if(isset($errors['photo_type'])): ?><p class="mt-2 text-sm text-red-600"><?php echo $errors['photo_type']; ?></p><?php endif; ?>
            </div>
            <div class="md:col-span-2">
                <label for="caption" class="block text-sm font-bold text-brand-blue dark:text-gray-200 mb-1">Optional Caption</label>
                <input type="text" name="caption" id="caption" class="block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-2 px-4 py-3 text-base">
            </div>
            <div class="md:col-span-3">
                 <label for="project_photo" class="block text-sm font-bold text-brand-blue dark:text-gray-200 mb-1">Photo File</label>
                 <input type="file" name="project_photo" id="project_photo" required class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-violet-50 file:text-brand-purple hover:file:bg-violet-100">
            </div>
        </div>
        <div class="mt-6 flex justify-end">
             <button type="submit" name="upload_photo" class="inline-flex justify-center rounded-md border border-transparent bg-brand-orange py-2 px-4 text-sm font-medium text-white shadow-sm hover:bg-opacity-90">Upload Photo</button>
        </div>
    </form>

    <!-- Photo Gallery -->
    <h3 class="text-lg font-semibold text-brand-orange mt-8 mb-4">Existing Photos</h3>
    <?php if (empty($project_photos)): ?>
        <p class="text-gray-500 dark:text-gray-400">No photos have been uploaded for this project yet.</p>
    <?php else: ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php foreach ($project_photos as $photo): ?>
                <div class="group relative rounded-lg overflow-hidden shadow-md">
                    <img src="uploads/<?php echo e($photo['image_url']); ?>" alt="<?php echo e($photo['caption']); ?>" class="h-48 w-full object-cover">
                    <div class="absolute bottom-0 left-0 right-0 p-2 bg-black bg-opacity-60 text-white">
                        <p class="text-sm font-bold"><?php echo e($photo['photo_type']); ?></p>
                        <p class="text-xs truncate"><?php echo e($photo['caption']); ?></p>
                    </div>
                    <a href="delete_photo.php?id=<?php echo $photo['id']; ?>&project_id=<?php echo $project_id; ?>" class="absolute top-2 right-2 bg-red-600 text-white rounded-full p-1 opacity-0 group-hover:opacity-100 transition-opacity" onclick="return confirm('Are you sure you want to delete this photo?');">
                        <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" /></svg>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>
