<?php
// FILE: admin/index.php
// PURPOSE: Acts as a smart router for the /admin/ directory.
// It checks if the user is logged in and redirects them to the appropriate page.

// We need the session to be started to check the login status.
// Our functions.php file already handles this.
require_once 'functions.php';

// Check if the user is logged in by looking at the session variable.
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
    // If they are logged in, send them to the main dashboard.
    header("location : dashboard.php");
    exit;
} else {
    // If they are not logged in, send them to the login page.
    header("location : login.php");
    exit;
}
