<?php
// FILE: admin/delete_media.php
// PURPOSE: Handles the secure deletion of a media file.

require_once 'functions.php';
require_once 'db.php';

// Security: Only Admins and SuperAdmins can delete
require_login();
if (!is_admin() && !is_super_admin()) {
    header("location: media_library.php?error=permission_denied");
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['image_id'])) {
    $image_id = $_POST['image_id'];
    
    try {
        $pdo->beginTransaction();
        
        // First, get the filename to delete it from the server
        $stmt = $pdo->prepare("SELECT file_name FROM media_gallery WHERE id = :id");
        $stmt->execute(['id' => $image_id]);
        $image = $stmt->fetch();

        if ($image) {
            // Delete the database record
            $delete_stmt = $pdo->prepare("DELETE FROM media_gallery WHERE id = :id");
            $delete_stmt->execute(['id' => $image_id]);

            // Delete the actual file
            $file_path = 'uploads/' . $image['file_name'];
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            
            log_action($pdo, "Deleted Media File", "MediaGallery", $image_id);
            $pdo->commit();
            header("location: media_library.php?success=deleted");
            exit;
        } else {
            $pdo->rollBack();
            header("location: media_library.php?error=not_found");
            exit;
        }

    } catch (PDOException $e) {
        $pdo->rollBack();
        header("location: media_library.php?error=db_error");
        exit;
    }
} else {
    // If not a POST request, redirect away
    header("location: media_library.php");
    exit;
}
