<?php
// FILE: admin/create_admin.php
// PURPOSE: To create a new SuperAdmin user with a securely hashed password.
// USAGE: Run this file once in your browser, then DELETE IT immediately.

require_once 'db.php'; // Includes the database connection

// --- User Details ---
$name = 'Lydia Rosasi';
$email = 'lydiarosasi95@gmail.com'; // Using the provided email
$password = 'Admin@123'; // The plain-text password
$role = 'SuperAdmin';
$ward_id = null; // SuperAdmins are not tied to a specific ward

// --- Hashing the Password ---
// This is the most important step. We use PHP's built-in secure hashing function.
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

echo "<!DOCTYPE html><html lang='en'><body style='font-family: sans-serif; padding: 20px;'>";
echo "<h1>Admin User Creation Script</h1>";

try {
    // Check if the user already exists
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = :email");
    $stmt->execute(['email' => $email]);
    if ($stmt->fetch()) {
        echo "<p style='color: orange;'><strong>Warning:</strong> A user with the email/username '<strong>" . htmlspecialchars($email) . "</strong>' already exists. No new user was created.</p>";
    } else {
        // --- Inserting the New User ---
        // Prepare the SQL INSERT statement
        $sql = "INSERT INTO users (name, email, password, role, ward_id) VALUES (:name, :email, :password, :role, :ward_id)";
        $stmt = $pdo->prepare($sql);

        // Bind the parameters and execute the statement
        $stmt->execute([
            'name' => $name,
            'email' => $email,
            'password' => $hashed_password,
            'role' => $role,
            'ward_id' => $ward_id
        ]);

        echo "<p style='color: green;'><strong>Success!</strong> SuperAdmin user '<strong>" . htmlspecialchars($email) . "</strong>' has been created.</p>";
        echo "<p>You can now log in using this email and the password '<strong>" . htmlspecialchars($password) . "</strong>'.</p>";
    }

} catch (PDOException $e) {
    // Handle any database errors
    echo "<p style='color: red;'><strong>Error:</strong> Could not create user. " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p style='font-weight: bold; color: red;'>IMPORTANT: Please delete this file (`create_admin.php`) from your server immediately!</p>";
echo "</body></html>";

?>
