<?php
// FILE: admin/set_featured_photo.php
// PURPOSE: Handles the AJAX request to set a photo as the featured image for a project.

header('Content-Type: application/json');
require_once 'db.php';
require_once 'functions.php';
require_login();

// Allow only admins and super admins to set a featured photo
if (!is_admin() && !is_super_admin()) {
    echo json_encode(['success' => false, 'message' => 'Permission denied.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$project_id = $data['project_id'] ?? null;
$photo_id = $data['photo_id'] ?? null;

if (!$project_id || !$photo_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid Project or Photo ID.']);
    exit;
}

try {
    $pdo->beginTransaction();
    
    // Step 1: Set all photos for this project to is_featured = 0
    $reset_sql = "UPDATE project_photos SET is_featured = 0 WHERE project_id = ?";
    $pdo->prepare($reset_sql)->execute([$project_id]);
    
    // Step 2: Set the selected photo to is_featured = 1
    $set_sql = "UPDATE project_photos SET is_featured = 1 WHERE id = ? AND project_id = ?";
    $stmt = $pdo->prepare($set_sql);
    $stmt->execute([$photo_id, $project_id]);
    
    log_action($pdo, 'Set Featured Photo', 'Project', $project_id, "Set photo ID {$photo_id} as featured.");
    
    $pdo->commit();
    echo json_encode(['success' => true, 'message' => 'Featured photo updated.']);

} catch (PDOException $e) {
    $pdo->rollBack();
    error_log("Set Featured Photo Error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'A database error occurred.']);
}
?>