<?php
// FILE: admin/partials/project_danger_zone.php
?>
<div class="bg-white rounded-xl shadow-md p-8 border-2 border-red-200">
    <h3 class="text-xl font-semibold text-red-700">Danger Zone</h3>
    <div class="mt-4 border-t border-red-200 pt-4">
        <div class="flex items-center justify-between">
            <div>
                <h4 class="font-semibold text-gray-800">Delete This Project</h4>
                <p class="text-sm text-gray-600 max-w-xl mt-1">Once you delete a project, all of its data, including all associated photos, will be permanently removed. This action cannot be undone.</p>
            </div>
            <form action="manage_project.php?id=<?php echo e($project_id); ?>" method="POST" onsubmit="return confirm('Are you absolutely sure? This action is irreversible.');">
                <input type="hidden" name="csrf_token" value="<?php echo e($csrf_token); ?>">
                <input type="hidden" name="action" value="delete_project">
                <button type="submit" class="px-4 py-2 text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700">
                    Delete Project
                </button>
            </form>
        </div>
    </div>
</div>
