<?php
// FILE: admin/includes/auth_check.php
// PURPOSE: To be included in a global header. Checks for a "remember me" cookie
// and automatically logs the user in if the token is valid.

// Ensure this file isn't accessed directly
if (!defined('IS_INCLUDED')) {
    // A simple check. You can define IS_INCLUDED in your header.php before including this file.
    // define('IS_INCLUDED', true);
    die("Direct access is not permitted.");
}

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// If the user is already logged in via session, no need to check the cookie.
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
    return;
}

// Check if the "remember_me" cookie is set
if (isset($_COOKIE['remember_me']) && !empty($_COOKIE['remember_me'])) {
    
    // Split the cookie into selector and validator
    list($selector, $validator) = explode(':', $_COOKIE['remember_me'], 2);

    if ($selector && $validator) {
        require_once __DIR__ . '/../db.php'; // Adjust path to db.php as needed

        try {
            // Find the token in the database using the selector
            $stmt = $pdo->prepare("SELECT * FROM auth_tokens WHERE selector = :selector AND expires >= NOW() LIMIT 1");
            $stmt->execute(['selector' => $selector]);
            $token_data = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($token_data) {
                // Token found, now verify the validator
                $hashed_validator_from_db = $token_data['hashed_validator'];
                
                if (password_verify($validator, $hashed_validator_from_db)) {
                    // Token is valid! Log the user in.
                    
                    // Fetch the user's details
                    $user_stmt = $pdo->prepare("SELECT id, name, role, ward_id FROM users WHERE id = :id AND is_active = 1");
                    $user_stmt->execute(['id' => $token_data['user_id']]);
                    $user = $user_stmt->fetch(PDO::FETCH_ASSOC);

                    if ($user) {
                        // Regenerate session ID for security
                        session_regenerate_id(true);

                        // Set session variables
                        $_SESSION["loggedin"] = true;
                        $_SESSION["id"] = $user['id'];
                        $_SESSION["name"] = $user['name'];
                        $_SESSION["role"] = $user['role'];
                        $_SESSION["ward_id"] = $user['ward_id'];
                    }
                }
            }

        } catch (PDOException $e) {
            // Log the error, but don't show it to the user
            error_log('Auth token check failed: ' . $e->getMessage());
        }
    }
}
