<?php
// FILE: admin/delete_photo.php
// PURPOSE: Handles the AJAX request to delete a project photo.

header('Content-Type: application/json');
require_once 'db.php';
require_once 'functions.php';
require_login();

// Allow only admins and super admins to delete photos
if (!is_admin() && !is_super_admin()) {
    echo json_encode(['success' => false, 'message' => 'Permission denied.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$photo_id = $data['id'] ?? null;

if (!$photo_id || !filter_var($photo_id, FILTER_VALIDATE_INT)) {
    echo json_encode(['success' => false, 'message' => 'Invalid Photo ID.']);
    exit;
}

try {
    $pdo->beginTransaction();
    
    // First, get the filename to delete the actual file
    $stmt = $pdo->prepare("SELECT image_url, project_id FROM project_photos WHERE id = :id");
    $stmt->execute(['id' => $photo_id]);
    $photo = $stmt->fetch();

    if ($photo) {
        // Delete the database record
        $delete_stmt = $pdo->prepare("DELETE FROM project_photos WHERE id = :id");
        $delete_stmt->execute(['id' => $photo_id]);

        // Delete the file from the server
        $file_path = 'uploads/' . $photo['image_url'];
        if (file_exists($file_path)) {
            unlink($file_path);
        }
        
        // Log the action
        log_action($pdo, 'Deleted Photo', 'Project', $photo['project_id']);
        
        $pdo->commit();
        echo json_encode(['success' => true, 'message' => 'Photo deleted successfully.']);
    } else {
        $pdo->rollBack();
        echo json_encode(['success' => false, 'message' => 'Photo not found.']);
    }
} catch (PDOException $e) {
    $pdo->rollBack();
    error_log("Photo Deletion Error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'A database error occurred.']);
}
?>