<?php
// FILE: admin/actions/project_upload_photo.php

if (isset($_FILES['project_photo']) && $_FILES['project_photo']['error'] === UPLOAD_ERR_OK) {
    $file = $_FILES['project_photo'];
    $caption = trim($_POST['caption'] ?? '');
    $photo_type = trim($_POST['photo_type'] ?? 'Progress');

    // Validation
    $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
    if (!in_array($file['type'], $allowed_types)) {
        $errors['photo'] = 'Invalid file type. Only JPG, PNG, and GIF are allowed.';
    } elseif ($file['size'] > 5 * 1024 * 1024) { // 5 MB limit
        $errors['photo'] = 'File is too large. Maximum size is 5 MB.';
    }

    if (empty($errors)) {
        $file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
        $new_file_name = 'proj_' . $project_id . '_' . uniqid() . '.' . $file_extension;
        $destination = PROJECT_PHOTOS_UPLOAD_DIR . $new_file_name;

        if (move_uploaded_file($file['tmp_name'], $destination)) {
            $sql = "INSERT INTO project_photos (project_id, file_name, file_path, caption, photo_type, uploaded_by) VALUES (:project_id, :file_name, :file_path, :caption, :photo_type, :uploaded_by)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                'project_id' => $project_id,
                'file_name' => $new_file_name,
                'file_path' => 'uploads/project_photos/' . $new_file_name, // Relative path for web
                'caption' => $caption,
                'photo_type' => $photo_type,
                'uploaded_by' => $_SESSION['id']
            ]);
            $success_message = "Photo uploaded successfully.";
        } else {
            $errors['photo'] = 'Failed to move uploaded file.';
        }
    }
} else {
    $errors['photo'] = 'No file was uploaded or an error occurred.';
}
