<?php
// FILE: admin/includes/sidebar.php
// PURPOSE: The new sidebar navigation component for the admin panel.

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// This helper function is now correctly located in functions.php
if (!function_exists('is_nav_active')) {
    function is_nav_active($page_name) {
        $current_page = basename($_SERVER['PHP_SELF']);
        if (is_array($page_name)) {
            return in_array($current_page, $page_name);
        }
        return $current_page == $page_name;
    }
}

// Check if we are on the manage_project page to show the dynamic link
$is_managing_project = is_nav_active('manage_project.php');
$project_id_for_link = $_GET['id'] ?? null;

// Check user permissions for menu visibility
$user_can_manage = is_super_admin() || is_admin();
$user_can_input = is_super_admin() || is_admin() || is_inputer();
?>
<div class="hidden lg:fixed lg:inset-y-0 lg:z-50 lg:flex lg:w-72 lg:flex-col">
    <!-- Sidebar component -->
    <div class="flex grow flex-col gap-y-5 overflow-y-auto bg-brand-blue px-6 pb-4">
        <div class="flex h-20 shrink-0 items-center">
             <a href="dashboard.php" class="flex items-center space-x-3">
                <img src="assets/hbc_logo.png" class="h-12 w-auto" alt="Homa Bay County Logo">
                <div class="h-10 w-px bg-white/30"></div>
                <div>
                    <span class="font-extrabold text-2xl text-white">GENOWA</span>
                    <span class="block font-semibold text-sm text-brand-orange -mt-1">DELIVERY UNIT</span>
                </div>
            </a>
        </div>
        <nav class="flex flex-1 flex-col">
            <ul role="list" class="flex flex-1 flex-col gap-y-7">
                <li>
                    <ul role="list" class="-mx-2 space-y-1">
                        <li>
                            <a href="dashboard.php" class="<?php echo is_nav_active('dashboard.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                               <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h7.5" /></svg>
                                Dashboard
                            </a>
                        </li>
                        
                         <?php if ($user_can_input): ?>
                        <li>
                            <a href="manage_project.php" class="<?php echo is_nav_active('manage_project.php') && !$project_id_for_link ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 9v6m3-3H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                Add Project
                            </a>
                        </li>
                        <?php endif; ?>
                        
                        <li>
                            <a href="gallery_dashboard.php" class="<?php echo is_nav_active(['gallery_dashboard.php', 'manage_gallery.php']) ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                               <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 001.5-1.5V6a1.5 1.5 0 00-1.5-1.5H3.75A1.5 1.5 0 002.25 6v12a1.5 1.5 0 001.5 1.5zm10.5-11.25h.008v.008h-.008V8.25zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" /></svg>
                                Galleries
                            </a>
                        </li>
                        
                        <?php if ($user_can_manage): ?>
                            <li>
                                <a href="news_dashboard.php" class="<?php echo is_nav_active(['news_dashboard.php', 'manage_article.php']) ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 7.5h1.5m-1.5 3h1.5m-7.5 3h7.5m-7.5 3h7.5m3-9h3.375c.621 0 1.125.504 1.125 1.125V18a2.25 2.25 0 01-2.25 2.25M16.5 7.5V18a2.25 2.25 0 002.25 2.25M16.5 7.5V4.875c0-.621-.504-1.125-1.125-1.125H4.125C3.504 3.75 3 4.254 3 4.875V18a2.25 2.25 0 002.25 2.25h13.5M6 7.5h3v3H6v-3z" /></svg>
                                    News & Updates
                                </a>
                            </li>
                            <li>
                                <a href="membership.php" class="<?php echo is_nav_active('membership.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M18 18.72a9.094 9.094 0 003.741-.479 3 3 0 00-4.682-2.72m-7.289 2.72a9.094 9.094 0 013.741-.479 3 3 0 014.682-2.72m-7.289 2.72a3 3 0 00-4.682 2.72m7.289-2.72v-2.72a3 3 0 00-3-3H9.72a3 3 0 00-3 3v2.72m0-2.72a3 3 0 013-3h3.57a3 3 0 013 3v2.72" /></svg>
                                    Membership
                                </a>
                            </li>
                            <li>
                                <a href="issues_dashboard.php" class="<?php echo is_nav_active('issues_dashboard.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75" /></svg>
                                    Issues & Contacts
                                </a>
                            </li>
                            <li>
                                <a href="feedback_dashboard.php" class="<?php echo is_nav_active('feedback_dashboard.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                   <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M8.625 12a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H8.25m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H12m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0h-.375M21 12c0 4.556-4.03 8.25-9 8.25a9.764 9.764 0 01-2.555-.337A5.972 5.972 0 015.41 20.97a5.969 5.969 0 01-.474-.065 4.48 4.48 0 00.978-2.025c.09-.455.09-.934.018-1.402a5.969 5.969 0 01-2.12-3.468c-.204-.986-.204-2.03.003-3.037a5.969 5.969 0 012.12-3.468 4.48 4.48 0 00-.978-2.025c-.09-.455-.09-.934-.018-1.402a4.48 4.48 0 00.978-2.025c.09-.455.09-.934.018-1.402a5.969 5.969 0 012.12-3.468 4.48 4.48 0 00-.978-2.025A5.972 5.972 0 015.41 20.97a5.969 5.969 0 01-.474-.065 4.48 4.48 0 00.978-2.025c.09-.455.09-.934.018-1.402a5.969 5.969 0 01-2.12-3.468" /></svg>
                                    Public Feedback
                                </a>
                            </li>
                             <!-- New Knowledge Base Link -->
                            <li>
                                <a href="upload_knowledge.php" class="<?php echo is_nav_active(['upload_knowledge.php', 'view_knowledge.php']) ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 006 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 016 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 016-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0018 18a8.967 8.967 0 00-6 2.292m0-14.25v14.25" /></svg>
                                    Knowledge Base
                                </a>
                            </li>
                            <?php if (is_super_admin()): ?>
                            <li>
                                <a href="user_management.php" class="<?php echo is_nav_active('user_management.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-2.438c.155-.155.293-.31.429-.465a7.45 7.45 0 01.571-1.21a7.45 7.45 0 01.571 1.21c.136.155.274.31.429.465a9.337 9.337 0 004.121 2.438 9.38 9.38 0 002.625-.372M15 19.128v-3.86a2.25 2.25 0 01.9-1.75l1.375-1.032a2.25 2.25 0 012.822-.002l1.375 1.032a2.25 2.25 0 01.9 1.75v3.86M15 19.128c-1.423.238-2.92.372-4.5.372s-3.077-.134-4.5-.372m9 0a9.38 9.38 0 00-9 0m9 0c1.423-.238 2.92-.372 4.5-.372s3.077.134 4.5.372M5.25 19.128c-1.423.238-2.92.372-4.5.372s-3.077-.134-4.5-.372m9 0a9.38 9.38 0 00-9 0m9 0c1.423-.238 2.92-.372 4.5-.372s3.077.134 4.5.372m-4.5 3.72a9.337 9.337 0 00-4.121-2.438c-.155-.155-.293-.31-.429-.465a7.45 7.45 0 01-.571-1.21a7.45 7.45 0 01-.571 1.21c-.136.155.274.31.429.465a9.337 9.337 0 00-4.121 2.438 9.38 9.38 0 00-2.625-.372M5.25 19.128v-3.86a2.25 2.25 0 00-.9-1.75l-1.375-1.032a2.25 2.25 0 00-2.822.002L1.11 12.28a2.25 2.25 0 00-.9 1.75v3.86m4.5-3.72a9.337 9.337 0 004.121-2.438c.155-.155.293-.31.429-.465a7.45 7.45 0 01.571-1.21a7.45 7.45 0 01.571 1.21c.136.155.274.31.429.465a9.337 9.337 0 004.121 2.438 9.38 9.38 0 002.625-.372M5.25 19.128c1.423.238 2.92.372 4.5.372s3.077-.134 4.5-.372M15 5.25c0 .621-.504 1.125-1.125 1.125H10.125c-.621 0-1.125-.504-1.125-1.125v-1.5c0-.621.504-1.125 1.125-1.125h3.75c.621 0 1.125.504 1.125 1.125v1.5z" /></svg>
                                    Users
                                </a>
                            </li>
                             <li>
                                <a href="reports.php" class="<?php echo is_nav_active('reports.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m.75 12l3 3m0 0l3-3m-3 3v-6m-1.5-9H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" /></svg>
                                    PDF Reports
                                </a>
                            </li>
                             <li>
                                <a href="visual_report.php" class="<?php echo is_nav_active('visual_report.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                   <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6a7.5 7.5 0 100 15 7.5 7.5 0 000-15zM21 21l-5.197-5.197" /></svg>
                                    Visual Reports
                                </a>
                            </li>
                            <li>
                                <a href="generate_infographic.php" class="<?php echo is_nav_active('generate_infographic.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 001.5-1.5V6a1.5 1.5 0 00-1.5-1.5H3.75A1.5 1.5 0 002.25 6v12a1.5 1.5 0 001.5 1.5zm10.5-11.25h.008v.008h-.008V8.25zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" /></svg>
                                    Infographics
                                </a>
                            </li>
                             <li>
                                <a href="audit_log.php" class="<?php echo is_nav_active('audit_log.php') ? 'bg-brand-orange text-white' : 'text-gray-300 hover:bg-brand-purple hover:text-white'; ?> group flex gap-x-3 rounded-md p-3 text-sm leading-6 font-semibold">
                                    <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.604-3.75M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                    Audit Trails
                                </a>
                            </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </li>
                <li class="mt-auto">
                    <a href="../index.php" target="_blank" class="group -mx-2 flex gap-x-3 rounded-md p-2 text-sm font-semibold leading-6 text-gray-400 hover:bg-brand-purple hover:text-white">
                       <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M13.5 6H5.25A2.25 2.25 0 003 8.25v10.5A2.25 2.25 0 005.25 21h10.5A2.25 2.25 0 0018 18.75V10.5m-4.5 4.5v-4.5m0 0h-4.5m4.5 0l-9-9" /></svg>
                        View Public Site
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</div>
