<?php
// FILE: admin/includes/header.php
// PURPOSE: A reusable header file. Contains HTML head, session start, and the new sidebar layout structure.

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function is_nav_active($page_name) {
    return basename($_SERVER['PHP_SELF']) == $page_name;
}
?>
<!DOCTYPE html>
<html lang="en" class="h-full bg-white">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Genowa Delivery Unit - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700;800&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-blue': '#1E3A8A',
                        'brand-orange': '#F97316',
                        'brand-purple': '#6D28D9',
                        'brand-light-gray': '#F3F4F6',
                    }
                }
            }
        }
    </script>
    <style> body { font-family: 'Inter', sans-serif; } </style>
</head>
<body class="h-full">
    
    <?php if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true): ?>
    <div>
        <!-- Static sidebar for desktop -->
        <?php include 'sidebar.php'; ?>

        <div class="lg:pl-72">
            <!-- Simplified top bar -->
            <div class="sticky top-0 z-40 flex h-16 shrink-0 items-center gap-x-4 border-b border-gray-200 bg-white px-4 shadow-sm sm:gap-x-6 sm:px-6 lg:px-8">
                <!-- Mobile sidebar toggle -->
                <button type="button" id="mobile-sidebar-button" class="-m-2.5 p-2.5 text-gray-700 lg:hidden">
                    <span class="sr-only">Open sidebar</span>
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" /></svg>
                </button>

                <!-- Separator -->
                <div class="h-6 w-px bg-gray-900/10 lg:hidden" aria-hidden="true"></div>

                <div class="flex flex-1 gap-x-4 self-stretch lg:gap-x-6 justify-end">
                    <div class="flex items-center gap-x-4 lg:gap-x-6">
                        <span class="hidden lg:block lg:text-sm lg:font-semibold lg:leading-6 text-gray-900">Welcome, <?php echo e($_SESSION['name']); ?>!</span>
                        <a href="logout.php" class="text-sm font-medium text-brand-purple hover:text-brand-orange">Sign out</a>
                    </div>
                </div>
            </div>

            <!-- This is where the main page content will start -->
            <main class="py-10">
                <div class="px-4 sm:px-6 lg:px-8">
    <?php else: ?>
    <!-- This structure is for pages where the user is NOT logged in, like login.php -->
    <div class="h-full">
    <?php endif; ?>
