<?php
function get_approved_projects(PDO $pdo): array {
    try {
        $stmt = $pdo->query("SELECT id, name FROM projects WHERE is_approved = 1 ORDER BY name ASC");
        return $stmt->fetchAll();
    } catch (PDOException $e) {
        return [];
    }
}

function get_article_by_id(PDO $pdo, int $id): ?array {
    try {
        $stmt = $pdo->prepare("SELECT * FROM news_articles WHERE id = :id");
        $stmt->execute(['id' => $id]);
        $article = $stmt->fetch(PDO::FETCH_ASSOC);
        return $article ?: null;
    } catch (PDOException $e) {
        return null;
    }
}

function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

function require_login() {
    session_start();
    if (!isset($_SESSION['id'])) {
        header("Location: login.php");
        exit;
    }
}

function is_admin() {
    return isset($_SESSION['role']) && in_array($_SESSION['role'], ['Admin', 'Super Admin']);
}

function is_super_admin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'Super Admin';
}

function log_action(PDO $pdo, string $action, string $module, int $ref_id): void {
    try {
        $stmt = $pdo->prepare("INSERT INTO activity_logs (user_id, action, module, ref_id, created_at) VALUES (:user_id, :action, :module, :ref_id, NOW())");
        $stmt->execute([
            'user_id' => $_SESSION['id'],
            'action' => $action,
            'module' => $module,
            'ref_id' => $ref_id
        ]);
    } catch (PDOException $e) {
        // Fail silently or log elsewhere
    }
}
